unit UKlasy;

interface

Uses
   Classes, Graphics, ExtCtrls;


const cGRUBOSC = 20;

Type

Figura = class(TObject)
private
	Canvas 	   : TCanvas;
   width       : Integer;
   height      : Integer;
	x1          : Integer;
   y1          : Integer;
   x2          : Integer;
   y2          : Integer;
   etykieta    : String;
   w_gore      : Boolean;
   w_lewo      : Boolean;
   skok        : Integer;
   pen_color   : TColor;
   brush_color : TColor;

public
   function  Get_x1() : Integer;
   function  Get_y1() : Integer;
   function  Get_x2() : Integer;
   function  Get_y2() : Integer;

   function  Get_w_gore() : Boolean;
   function  Get_w_lewo() : Boolean;

	procedure Set_w_gore(Value : Boolean);
	procedure Set_w_lewo(Value : Boolean);
	procedure Set_skok(Value: Integer);
	procedure Set_r(x1_, y1_, x2_, y2_ : Integer);
	procedure Set_area(x1_, y1_, x2_, y2_ : Integer);
	procedure Get_area(var x1_: Integer; var y1_ : Integer; var x2_ : Integer; var y2_ : Integer);
	procedure Get_etykieta(var nazwa : String);

	procedure Show(); virtual;
	procedure Move(); virtual;

	constructor Create(Canvas_            : TCanvas;
                      etykieta_          : String;
                      x1_, y1_, x2_, y2_ : Integer;
                      w_gore_            : Boolean;
                      w_lewo_            : Boolean;
                      skok_              : Integer;
                      pen_color_         : TColor;
                      brush_color_       : TColor;
                      width_             : Integer;
                      height_            : Integer);

	destructor Destroy(); override;
end;

implementation
Uses
   Main;
{------------------------------------------------------------------------------}
constructor Figura.Create(Canvas_            : TCanvas;
                          etykieta_          : String;
                          x1_, y1_, x2_, y2_ : Integer;
                          w_gore_            : Boolean;
                          w_lewo_            : Boolean;
                          skok_              : Integer;
                          pen_color_         : TColor;
                          brush_color_       : TColor;
                          width_             : Integer;
                          height_            : Integer);
begin

	etykieta    := etykieta_;

	Canvas      := Canvas_;

	x1          := x1_;
   y1          := y1_;
   x2          := x2_;
   y2          := y2_;

   w_gore      := w_gore_;
   w_lewo      := w_lewo_;

   SKOK        := skok_;

	pen_color   := pen_color_;
   brush_color := brush_color_;

   width       := width_;
   height      := height_;
end;

destructor Figura.Destroy();
begin
	inherited;
end;

procedure Figura.Set_w_gore(Value : Boolean);
begin
	w_gore := Value;
end;

procedure Figura.Set_w_lewo(Value : Boolean);
begin
	w_lewo := Value;
end;

procedure Figura.Set_skok(Value : Integer);
begin
	SKOK := Value;
end;

procedure Figura.Set_r(x1_, y1_, x2_, y2_ : Integer);
begin
	x1 := x1_;
   y1 := y1_;
   x2 := x2_;
   y2 := y2_;
end;

procedure Figura.Set_area(x1_, y1_, x2_, y2_ : Integer);
begin
	x1 := x1_;
   y1 := y1_;
   x2 := x2_;
   y2 := x2_;
end;

procedure Figura.Get_area(var x1_: Integer; var y1_ : Integer; var x2_ : Integer; var y2_ : Integer);
begin
	x1_ := x1;
   y1_ := y1;
   x2_ := x2;
   y2_ := y2;
end;

procedure Figura.Show();
var
   old_pen_color   : TColor;
   old_brush_color : TColor;

begin
	// zapamitaj stare ustawienia
   old_pen_color   := Canvas.Pen.Color;
   old_brush_color := Canvas.Brush.Color;

	Canvas.Pen.Color   := pen_color;
	Canvas.Brush.Color := brush_color;

	Canvas.Rectangle(x1, y1, x2, y2);
   // wypisz etykiet figury w jej wewntrznym obszarze
   Canvas.TextOut(x1+2, y1+2, etykieta);

   // przywr poprzednie ustawienia
   Canvas.Pen.Color   := old_pen_color;
   Canvas.Brush.Color := old_brush_color;
end;

procedure Figura.Get_etykieta(var nazwa : String);
begin
   nazwa := etykieta;
end;

function Figura.Get_x1() : Integer;
begin
	Result := x1;
end;

function Figura.Get_y1() : Integer;
begin
	Result := y1;
end;

function Figura.Get_x2() : Integer;
begin
	Result := x2;
end;

function Figura.Get_y2() : Integer;
begin
	Result := y2;
end;

function Figura.Get_w_gore() : Boolean;
begin
	Result := w_gore;
end;

function Figura.Get_w_lewo() : Boolean;
begin
	Result := w_lewo;
end;

procedure Figura.Move();
var
   szer : Integer;
   wys  : Integer;

begin
	// wysoko i szeroko figury
   szer := 0;
   wys  := 0;

   wys  := y2 - y1;
   szer := x2 - x1;

   if w_lewo then
   begin
      if (x1 - SKOK) >= cGRUBOSC then
      begin
         x1 := x1 - SKOK;
         x2 := x2 - SKOK;
      end
      else begin
         w_lewo := false;
      end;
   end
   else begin
      // figura porusza si w prawo
      if((x1 + szer + SKOK) <= (width - cGRUBOSC)) then
      begin
         x1 := x1 + SKOK;
         x2 := x2 + SKOK;
      end
      else begin
         w_lewo := true;
      end;
   end;

   // figura porusza si w gr
   if w_gore then
   begin
      if((y1 - SKOK) >= cGRUBOSC) then
      begin
         y1 := y1 - SKOK;
         y2 := y2 - SKOK;
      end
      else begin
         w_gore := false;
      end;
   end
   else begin
   	// figura porusza si w d
      if((y1 + wys + SKOK) <= (Form1.Panel4.Top)) then
      begin
         y1 := y1 + SKOK;
         y2 := y2 + SKOK;
      end
      else begin
         w_gore := true;
      end;
   end;
end;

end.

